from pydantic import BaseModel, Field, EmailStr
from typing import Optional
from datetime import datetime

class Address(BaseModel):
    street: str
    city: str
    state: str
    country: str
    postal_code: str

class CustomerAccount(BaseModel):
    account_id: str = Field(..., description="Tenant/organization ID")
    customer_id: Optional[str] = Field(None, description="Primary customer reference")
    company_name: str = Field(..., description="Enterprise company name")
    contact_person: str = Field(..., description="Primary contact name")
    phone: str = Field(..., description="Contact number")
    email: EmailStr = Field(..., description="Email address")
    address: Address
    created_date: datetime = Field(default_factory=datetime.utcnow)
    updated_date: datetime = Field(default_factory=datetime.utcnow)

